function plotNeurons(varargin)

% Requires MATLAB R2014b or later, and the following Toolboxes:
% Signal Processing Toolbox
% Image Processing Toolbox
% Statistics and Machine Learning Toolbox
% Database Toolbox
% Model-Based Calibration Toolbox
% Bioinformatics Toolbox

if nargin < 1
    % default root folder for all the Variables*.mat and neurons.mat files
    pathInput = '\\101.101.1.113\data\Ippei\Publication\Neurons\N2';
elseif nargin == 1
    pathInput = varargin{1};
else
    error('Too many input arguments');
end
%=================================================================================================================================
nm = neuronManager;
%=================================================================================================================================
nm.flgMergeLR = true;
nm.flgMeanLR = false;
nm.modeNormalization = 'bottom';
nm.flgSynchLaser= true;
% nm.selectedNeurons = {'AIY'};
%=================================================================================================================================
b = nm.readFiles(pathInput, 'neurons.mat'); if ~b, return, end
rateSampling = 1;
b = nm.parseFiles(rateSampling); if ~b, return, end
nm.sortNeurons;
nm.getStats;
nm.getLaserOutput;
nm.saveStats;
nm.saveObject;
%=================================================================================================================================
scrollablePlots(nm);
